/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContainingInOrder;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayContainingInOrderTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsArrayContainingInOrder.arrayContaining((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2)});
    }

    public void testHasAReadableDescription() {
        IsArrayContainingInOrderTest.assertDescription("[<1>, <2>]", IsArrayContainingInOrder.arrayContaining((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2)}));
    }

    public void testMatchesItemsInOrder() {
        IsArrayContainingInOrderTest.assertMatches("in order", IsArrayContainingInOrder.arrayContaining((Object[])new Integer[]{1, 2, 3}), new Integer[]{1, 2, 3});
        IsArrayContainingInOrderTest.assertMatches("single", IsArrayContainingInOrder.arrayContaining((Object[])new Integer[]{1}), new Integer[]{1});
    }

    public void testAppliesMatchersInOrder() {
        IsArrayContainingInOrderTest.assertMatches("in order", IsArrayContainingInOrder.arrayContaining((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2), IsEqual.equalTo((Object)3)}), new Integer[]{1, 2, 3});
        IsArrayContainingInOrderTest.assertMatches("single", IsArrayContainingInOrder.arrayContaining((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1)}), new Integer[]{1});
    }

    public void testMismatchesItemsInOrder() {
        Matcher matcher = IsArrayContainingInOrder.arrayContaining((Object[])new Integer[]{1, 2, 3});
        IsArrayContainingInOrderTest.assertMismatchDescription("was null", matcher, null);
        IsArrayContainingInOrderTest.assertMismatchDescription("No item matched: <1>", matcher, new Integer[0]);
        IsArrayContainingInOrderTest.assertMismatchDescription("No item matched: <2>", matcher, new Integer[]{1});
        IsArrayContainingInOrderTest.assertMismatchDescription("item 0: was <4>", matcher, new Integer[]{4, 3, 2, 1});
        IsArrayContainingInOrderTest.assertMismatchDescription("item 2: was <4>", matcher, new Integer[]{1, 2, 4});
    }
}

